#!/bin/bash
#SBATCH -J value_expansion
#SBATCH -a 1-6
#SBATCH -n 1
#SBATCH -c 1
#SBATCH --mem-per-cpu=6144
#SBATCH --gres=gpu:1
#SBATCH -t 72:00:00
#SBATCH -o # TODO: output file here
#SBATCH -e # TODO: output file here
## Make sure to create the logs directory /home/user/Documents/projects/prog/logs, BEFORE launching the jobs.

# Setup Env
if [ -n "$SLURM_JOB_ID" ];  then
    SCRIPT_PATH=$(dirname $(scontrol show job $SLURM_JOBID | awk -F= '/Command=/{print $2}'))
else
    # otherwise: started with bash. Get the real location.
    SCRIPT_PATH=$(readlink -f $(dirname $0))
fi

source $SCRIPT_PATH/_setup_env.sh
setup

GPU=0
s=$SLURM_ARRAY_TASK_ID

# Past the following line to queue experiments for inverted pendulum on slurm cluster
# for a in 'SAC-RETRACE' 'SAC-MVE' 'SAC-VG'; do for env in 'inverted_pendulum'; do for m in 'analytic' 'network'; do for h in 0 1 3 5; do A=$a ENV=$env H=$h M=$m sbatch slurm.sh; done ; done; done; done

python brax_experiment.py -env $ENV -algo $A -gpu $GPU -seed $s -H $H -model_type $M
